<?php
require_once(__DIR__ . '/../../../init.php');
require_once(__DIR__ . '/../../../includes/gatewayfunctions.php');
require_once(__DIR__ . '/../../../includes/invoicefunctions.php');

$gatewaymodule = 'baniapp';

$GATEWAY = getGatewayVariables($gatewaymodule);

if (!function_exists("baniapp_redirect"))
{
	function baniapp_redirect($url)
	{
		@header('Location: '. $url);
		echo "<meta http-equiv='refresh' content='0; url={$url}' />";
	}
}

if (!function_exists("baniapp_encrypt_decrypt"))
{
	function baniapp_encrypt_decrypt($action, $string)
	{
		$output 		= false;
		$encrypt_method = "AES-256-CBC";
		$secret_key 	= md5("697A375ACA3F2");
		$secret_iv 		= md5($secret_key);
		$key 			= hash('sha256', $secret_key);
		$iv 			= substr(hash('sha256', $secret_iv), 0, 16);

		if ( $action == 'encrypt' )
		{
			$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
			$output = base64_encode($output);
		} else if( $action == 'decrypt' ) {
			$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
		}

		return $output;
	}
}

$ReturnData = (isset($_GET['return']) && $_GET['return'] != "") ? $_GET['return'] : "";
$ReturnData = baniapp_encrypt_decrypt("decrypt", $ReturnData);
$ReturnData = explode("|", $ReturnData);

$Amount 	= (isset($ReturnData[1]) && $ReturnData[1] != "") ? $ReturnData[1] : 0;
$Authority  = (isset($_POST['Authority']) && $_POST['Authority'] != "") ? $_POST['Authority'] : "";

$invoiceid  = (isset($ReturnData[0]) && $ReturnData[0] != "") ? $ReturnData[0] : 0;
$invoiceid  = checkCbInvoiceID($invoiceid, $GATEWAY['name']);

if (isset($_POST['PaymentStatus']) && $_POST['PaymentStatus'] == 'OK')
{
	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, 'https://baniapp.ir/webservice/rest/PaymentVerification');
	curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
	curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$GATEWAY['merchantID']}&Amount={$Amount}&Authority={$Authority}");
	curl_setopt($curl, CURLOPT_TIMEOUT, 30);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	$curl_exec = curl_exec($curl);
	curl_close($curl);

	$result = json_decode($curl_exec);

	if (isset($result->Status) && $result->Status == 100)
	{
		if ($result->Amount == $Amount)
		{
			addInvoicePayment($invoiceid, $result->RefID, $Amount, 0, $gatewaymodule);

			logTransaction($GATEWAY['name'], array(

				'Message'     	=> 'تراکنش با موفقیت انجام شد',
				'RefID' 		=> $result->RefID,
				'Amount'      	=> $result->Amount,
				'Card Number' 	=> $result->MaskCardNumber

			), 'Success');
		} else {
			logTransaction($GATEWAY['name'], array(

				'Code'        	=> 'Transaction amount is invalid',
				'Message'     	=> 'مبلغ پرداخت شده معتبر نیست',
				'RefID' 		=> $result->RefID,
				'Invoice'     	=> $invoiceid

			), 'Failure');
		}
	} else {
		$resultCode = (isset($result->Status) && $result->Status != "") ? $result->Status : "Error connecting to web service";

		logTransaction($GATEWAY['name'], array(

			'Code'        	=> $resultCode,
			'Message'     	=> 'تراکنش ناموفق با کد خطای : '. $resultCode,
			'RefID' 		=> $result->RefID,
			'Invoice'     	=> $invoiceid

		), 'Failure');
	}
} else {
	logTransaction($GATEWAY['name'], array(

		'Code'        => 'Transaction Cancelled',
		'Message'     => 'تراکنش توسط کاربر لغو شده است',
		'RefID' => '',
		'Invoice'     => $invoiceid

	), 'Failure');
}

$SystemURL 	= (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
$SystemURL 	= str_replace("\\", "/", $SystemURL);
$SystemURL 	= substr($SystemURL, 0, strpos($SystemURL, "modules/gateways"));
$SystemURL 	= rtrim($SystemURL, "/");
$SystemURL 	= (isset($CONFIG['SystemURL']) && $CONFIG['SystemURL'] != "") ? $CONFIG['SystemURL'] : $SystemURL;
$SystemURL 	= "{$SystemURL}/viewinvoice.php?id={$invoiceid}";

baniapp_redirect($SystemURL);
@header("Location: {$SystemURL}");
?>