<?php
/*
Plugin Name: حمایت مالی بانی اپ
Plugin URI: https://baniapp.ir
Description: افزونه حمایت مالی از وبسایت ها -- برای استفاده تنها کافی است کد زیر را درون بخشی از برگه یا نوشته خود قرار دهید  [baniAppDonate]
Version: 1.0
Author: Milad Maldar
Author URI: http://miladworkshop.ir
*/

defined('ABSPATH') or die('Access denied!');

define ('baniAppDonateDIR', plugin_dir_path( __FILE__ ));
define ('LIBDIR'  , baniAppDonateDIR.'/lib');
define ('TABLE_DONATE'  , 'baniapp_donate');

require_once ABSPATH . 'wp-admin/includes/upgrade.php';

if ( is_admin() )
{
	add_action('admin_menu', 'BANIAPP_AdminMenuItem');

	function BANIAPP_AdminMenuItem()
	{
		add_menu_page( 'تنظیمات افزونه حمایت مالی - بانی اپ', 'حمات مالی', 'administrator', 'BANIAPP_MenuItem', 'BANIAPP_MainPageHTML', '', 6); 
		add_submenu_page('BANIAPP_MenuItem','نمایش حامیان مالی','نمایش حامیان مالی', 'administrator','baniAppDonations','baniAppDonationsHTML');
	}
}

function BANIAPP_MainPageHTML()
{
	include('baniAppAdmin.php');
}

function baniAppDonationsHTML()
{
	include('baniAppDonations.php');
}


add_action( 'init', 'baniAppDonateShortcode');

function baniAppDonateShortcode(){
	add_shortcode('baniAppDonate', 'baniAppDonateForm');
}

function baniAppDonateForm()
{
	$out 									= '';
	$error 									= '';
	$message 								= '';
  
	$MerchantID 							= get_option( 'BANIAPP_MerchantID');
	$BANIAPP_IsOK 		= get_option( 'BANIAPP_IsOK');
	$BANIAPP_IsError 	= get_option( 'BANIAPP_IsError');
	$BANIAPP_Unit 		= get_option( 'BANIAPP_Unit');
  
	$Amount 								= '';
	$Description 							= '';
	$Name 									= '';
	$Mobile 								= '';
	$Email 									= '';
  
	/////////////////////- START REQUEST -/////////////////////
	if(isset($_POST['submit']) && $_POST['submit'] == 'پرداخت')
	{
		if($MerchantID == '')
		{
			$error = 'کد دروازه پرداخت وارد نشده است' . "<br>\r\n";
		}

		$Amount = filter_input(INPUT_POST, 'BANIAPP_Amount', FILTER_SANITIZE_SPECIAL_CHARS);

		if(is_numeric($Amount) != false)
		{
			if($BANIAPP_Unit == 'ریال')
			$SendAmount =  $Amount / 10;
			else
			$SendAmount =  $Amount;
		} else {
			$error .= 'مبلغ به درستی وارد نشده است' . "<br>\r\n";
		}

		$Description 		= filter_input(INPUT_POST, 'BANIAPP_Description', FILTER_SANITIZE_SPECIAL_CHARS);  // Required
		$Name 				= filter_input(INPUT_POST, 'BANIAPP_Name', FILTER_SANITIZE_SPECIAL_CHARS);  // Required
		$Mobile 			= filter_input(INPUT_POST, 'mobile', FILTER_SANITIZE_SPECIAL_CHARS); // Optional
		$Email 				= filter_input(INPUT_POST, 'email', FILTER_SANITIZE_SPECIAL_CHARS); // Optional
		$SendDescription 	= $Name . ' | ' . $Mobile . ' | ' . $Email . ' | ' . $Description ;  

		if($error == '')
		{
			$CallbackURL 	= BANIAPP_GetCallBackURL();  // Required

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://baniapp.ir/webservice/rest/PaymentRequest');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$SendAmount}&InvoiceID={$InvoiceID}&Description={$SendDescription}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);

			$result = json_decode($curl_exec);

			if (isset($result->Status) && $result->Status == 100)
			{
				BANIAPP_AddDonate(array(
					'Authority'     => $result->Authority,
					'Name'          => $Name,
					'AmountTomaan'  => $SendAmount,
					'Mobile'        => $Mobile,
					'Email'         => $Email,
					'InputDate'     => current_time( 'mysql' ),
					'Description'   => $Description,
					'Status'        => 'SEND'
				),array(
					'%s',
					'%s',
					'%d',
					'%s',
					'%s',
					'%s',
					'%s',
					'%s'
				));

				return "<script>document.location = '{$result->PaymentUrl}'</script><center>در صورتی که به صورت خودکار به درگاه بانک منتقل نشدید <a href='{$result->PaymentUrl}'>اینجا</a> را کلیک کنید.</center>";
			} else {
				$error .= BANIAPP_GetResaultStatusString($result->Status) . "<br>\r\n";
			}
		}
	}
	////////////////////////- END REQUEST -////////////////////////
  
  
	//////////////////////- START  RESPONSE -//////////////////////
	if (isset($_POST['Authority']) && $_POST['Authority'] != "")
	{
		$Authority = (isset($_POST['Authority']) && $_POST['Authority'] != "") ? $_POST['Authority'] : "";

		if (isset($_POST['PaymentStatus']) && $_POST['PaymentStatus'] == 'OK')
		{
			$Record = BANIAPP_GetDonate($Authority);
	
			if($Record  === false)
			{
				$error .= 'چنین تراکنشی در سایت ثبت نشده است' . "<br>\r\n";
			} else {
				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, 'https://baniapp.ir/webservice/rest/PaymentVerification');
				curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
				curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$Record['AmountTomaan']}&Authority={$Record['Authority']}");
				curl_setopt($curl, CURLOPT_TIMEOUT, 30);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				$curl_exec = curl_exec($curl);
				curl_close($curl);

				$result = json_decode($curl_exec);

				if (isset($result->Status) && $result->Status == 100)
				{					
					BANIAPP_ChangeStatus($Authority, 'OK');
					$message .= get_option( 'BANIAPP_IsOk') . "<br>\r\n";
					$message .= 'کد پیگیری تراکنش:'. $result->RefID . "<br>\r\n";

					$BANIAPP_TotalAmount = get_option("BANIAPP_TotalAmount");
					update_option("BANIAPP_TotalAmount" , $BANIAPP_TotalAmount + $Record['AmountTomaan']);
				} else {
					BANIAPP_ChangeStatus($Authority, 'ERROR');
					$error .= get_option( 'BANIAPP_IsError') . "<br>\r\n";
					$error .= BANIAPP_GetResaultStatusString($result->Status) . "<br>\r\n";
				}
			}
		} else {
			$error .= 'تراکنش توسط کاربر بازگشت خورد';
			BANIAPP_ChangeStatus($Authority, 'CANCEL');
		}
	}
	//////////////////////- END RESPONSE -//////////////////////

	$style = '';

	if(get_option('BANIAPP_UseCustomStyle') == 'true')
	{
		$style = get_option('BANIAPP_CustomStyle');
	} else {
		$style = '#BANIAPP_MainForm {  width: 400px;  height: auto;  margin: 0 auto;  direction: rtl; }  #BANIAPP_Form {  width: 96%;  height: auto;  float: right;  padding: 10px 2%; }  #BANIAPP_Message,#BANIAPP_Error {  width: 90%;  margin-top: 10px;  margin-right: 2%;  float: right;  padding: 5px 2%;  border-right: 2px solid #006704;  background-color: #e7ffc5;  color: #00581f; }  #BANIAPP_Error {  border-right: 2px solid #790000;  background-color: #ffc9c5;  color: #580a00; }  .BANIAPP_FormItem {  width: 90%;  margin-top: 10px;  margin-right: 2%;  float: right;  padding: 5px 2%; }    .BANIAPP_FormLabel {  width: 35%;  float: right;  padding: 3px 0; }  .BANIAPP_ItemInput {  width: 64%;  float: left; }  .BANIAPP_ItemInput input {  width: 90%;  float: right;  border-radius: 3px;  box-shadow: 0 0 2px #00c4ff;  border: 0px solid #c0fff0;  font-family: inherit;  font-size: inherit;  padding: 3px 5px; }  .BANIAPP_ItemInput input:focus {  box-shadow: 0 0 4px #0099d1; }  .BANIAPP_ItemInput input.error {  box-shadow: 0 0 4px #ef0d1e; }  input.BANIAPP_Submit {  background: none repeat scroll 0 0 #2ea2cc;  border-color: #0074a2;  box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15);  color: #fff;  text-decoration: none;  border-radius: 3px;  border-style: solid;  border-width: 1px;  box-sizing: border-box;  cursor: pointer;  display: inline-block;  font-size: 13px;  line-height: 26px;  margin: 0;  padding: 0 10px 1px;  margin: 10px auto;  width: 50%;  font: inherit;  float: right;  margin-right: 24%; }';
	}

	$out = '
  <style>
    '. $style . '
  </style>
      <div style="clear:both;width:100%;float:right;">
	        <div id="BANIAPP_MainForm">
          <div id="BANIAPP_Form">';
          
if($message != '')
{    
    $out .= "<div id=\"BANIAPP_Message\">
    ${message}
            </div>";
}

if($error != '')
{    
    $out .= "<div id=\"BANIAPP_Error\">
    ${error}
            </div>";
}

     $out .=      '<form method="post">
              <div class="BANIAPP_FormItem">
                <label class="BANIAPP_FormLabel">مبلغ :</label>
                <div class="BANIAPP_ItemInput">
                  <input style="width:60%" type="text" name="BANIAPP_Amount" value="'. $Amount .'" />
                  <span style="margin-right:10px;">'. $BANIAPP_Unit .'</span>
                </div>
              </div>
              
              <div class="BANIAPP_FormItem">
                <label class="BANIAPP_FormLabel">نام و نام خانوادگی :</label>
                <div class="BANIAPP_ItemInput"><input type="text" name="BANIAPP_Name" value="'. $Name .'" /></div>
              </div>
              
              <div class="BANIAPP_FormItem">
                <label class="BANIAPP_FormLabel">تلفن همراه :</label>
                <div class="BANIAPP_ItemInput"><input type="text" name="mobile" value="'. $Mobile .'" /></div>
              </div>
              
              <div class="BANIAPP_FormItem">
                <label class="BANIAPP_FormLabel">ایمیل :</label>
                <div class="BANIAPP_ItemInput"><input type="text" name="email" style="direction:ltr;text-align:left;" value="'. $Email .'" /></div>
              </div>
              
              <div class="BANIAPP_FormItem">
                <label class="BANIAPP_FormLabel">توضیحات :</label>
                <div class="BANIAPP_ItemInput"><input type="text" name="BANIAPP_Description" value="'. $Description .'" /></div>
              </div>
              
              <div class="BANIAPP_FormItem">
                <input type="submit" name="submit" value="پرداخت" class="BANIAPP_Submit" />
              </div>
            </form>
          </div>
        </div>
      </div>
	';

	return $out;
}

register_activation_hook(__FILE__,'baniAppDonate_install');
function baniAppDonate_install()
{
	BANIAPP_CreateDatabaseTables();
}

function BANIAPP_CreateDatabaseTables()
{
		global $wpdb;
		$baniappDonateTable = $wpdb->prefix . TABLE_DONATE;
		// Creat table
		$nazrezohoor = "CREATE TABLE IF NOT EXISTS `$baniappDonateTable` (
					  `DonateID` int(11) NOT NULL AUTO_INCREMENT,
					  `Authority` varchar(50) NOT NULL,
					  `Name` varchar(50) CHARACTER SET utf8 COLLATE utf8_persian_ci NOT NULL,
					  `AmountTomaan` int(11) NOT NULL,
					  `Mobile` varchar(11) ,
					  `Email` varchar(50),
					  `InputDate` varchar(20),
					  `Description` varchar(100) CHARACTER SET utf8 COLLATE utf8_persian_ci,
					  `Status` varchar(5),
					  PRIMARY KEY (`DonateID`),
					  KEY `DonateID` (`DonateID`)
					) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;";
		dbDelta($nazrezohoor);
		// Other Options
		add_option("BANIAPP_TotalAmount", 0, '', 'yes');
		add_option("BANIAPP_TotalPayment", 0, '', 'yes');
		add_option("BANIAPP_IsOK", 'با تشکر پرداخت شما به درستی انجام شد.', '', 'yes');
		add_option("BANIAPP_IsError", 'متاسفانه پرداخت انجام نشد.', '', 'yes');
    
    $style = '#BANIAPP_MainForm {
  width: 400px;
  height: auto;
  margin: 0 auto;
  direction: rtl;
}

#BANIAPP_Form {
  width: 96%;
  height: auto;
  float: right;
  padding: 10px 2%;
}

#BANIAPP_Message,#BANIAPP_Error {
  width: 90%;
  margin-top: 10px;
  margin-right: 2%;
  float: right;
  padding: 5px 2%;
  border-right: 2px solid #006704;
  background-color: #e7ffc5;
  color: #00581f;
}

#BANIAPP_Error {
  border-right: 2px solid #790000;
  background-color: #ffc9c5;
  color: #580a00;
}

.BANIAPP_FormItem {
  width: 90%;
  margin-top: 10px;
  margin-right: 2%;
  float: right;
  padding: 5px 2%;
}

.BANIAPP_FormLabel {
  width: 35%;
  float: right;
  padding: 3px 0;
}

.BANIAPP_ItemInput {
  width: 64%;
  float: left;
}

.BANIAPP_ItemInput input {
  width: 90%;
  float: right;
  border-radius: 3px;
  box-shadow: 0 0 2px #00c4ff;
  border: 0px solid #c0fff0;
  font-family: inherit;
  font-size: inherit;
  padding: 3px 5px;
}

.BANIAPP_ItemInput input:focus {
  box-shadow: 0 0 4px #0099d1;
}

.BANIAPP_ItemInput input.error {
  box-shadow: 0 0 4px #ef0d1e;
}

input.BANIAPP_Submit {
  background: none repeat scroll 0 0 #2ea2cc;
  border-color: #0074a2;
  box-shadow: 0 1px 0 rgba(120, 200, 230, 0.5) inset, 0 1px 0 rgba(0, 0, 0, 0.15);
  color: #fff;
  text-decoration: none;
  border-radius: 3px;
  border-style: solid;
  border-width: 1px;
  box-sizing: border-box;
  cursor: pointer;
  display: inline-block;
  font-size: 13px;
  line-height: 26px;
  margin: 0;
  padding: 0 10px 1px;
  margin: 10px auto;
  width: 50%;
  font: inherit;
  float: right;
  margin-right: 24%;
}';
  add_option("BANIAPP_CustomStyle", $style, '', 'yes');
  add_option("BANIAPP_UseCustomStyle", 'false', '', 'yes');
}

function BANIAPP_GetDonate($Authority)
{
	global $wpdb;

	$Authority = strip_tags($wpdb->escape($Authority));

	if($Authority == '')
		return false;

	$baniappDonateTable = $wpdb->prefix . TABLE_DONATE;

	$res = $wpdb->get_results( "SELECT * FROM ${baniappDonateTable} WHERE Authority = '${Authority}' LIMIT 1",ARRAY_A);

	if(count($res) == 0)
		return false;

	return $res[0];
}

function BANIAPP_AddDonate($Data, $Format)
{
	global $wpdb;

	if(!is_array($Data))
		return false;

	$baniappDonateTable = $wpdb->prefix . TABLE_DONATE;

	$res = $wpdb->insert( $baniappDonateTable , $Data, $Format);

	if($res == 1)
	{
		$totalPay = get_option('BANIAPP_TotalPayment');
		$totalPay += 1;
		update_option('BANIAPP_TotalPayment', $totalPay);
	}

	return $res;
}

function BANIAPP_ChangeStatus($Authority,$Status)
{
	global $wpdb;

	$Authority 	= strip_tags($wpdb->escape($Authority));
	$Status 	= strip_tags($wpdb->escape($Status));

	if($Authority == '' || $Status == '')
		return false;

	$baniappDonateTable = $wpdb->prefix . TABLE_DONATE;

	$res = $wpdb->query( "UPDATE ${baniappDonateTable} SET `Status` = '${Status}' WHERE `Authority` = '${Authority}'");

	return $res;
}

function BANIAPP_GetResaultStatusString($StatusNumber)
{
	switch($StatusNumber)
	{
		case -1:
			return 'درخواست باید از طریق متد ارسال شود';
		case -2:
			return 'مقداری برای MerchantID ارسال نشده است';
		case -3:
			return 'مقداری برای Amount ارسال نشده است';
		case -4:
			return 'مقداری برای CallbackURL ارسال نشده است';
		case -5:
			return 'حداقل مبلغ قابل پرداخت 100 تومان می‌باشد';
		case -6:
			return 'MerchantID وارد شده در سیستم یافت نشد';
		case -7:
			return 'MerchantID وارد شده فعال نیست';
		case -8:
			return 'اکانت شما تجاری نیست, لذا امکان استفاده از وبسرویس را ندارید';
		case -9:
			return 'IP معتبر نیست';
		case -10:
			return 'آدرس بازگشتی با آدرس درگاه پرداخت ثبت شده همخوانی ندارد';
		case -11:
			return 'خطای در وب سرویس - ایجاد تراکنش با خطا مواجه شد';
		case -12:
			return 'مقدار Authority ارسالی معتبر نیست - تراکنش یافت نشد';
		case -13:
			return 'مقداری برای Authority ارسال نشده است';
		case -14:
			return 'طلاعات تراکنش یافت نشد, مقدار Authority را بررسی کرده و صحیح بودن آن اطمانان حاصل کنید';
		case -15:
			return 'تراکنش پرداخت نشده است';
		case -16:
			return 'مبلغ ارسال شده با مبلغ تراکنش یکسان نیست, مقدار Amount را بررسی کرده و نسبت به صحت آن اطمینان حاصل کنید';
		case -17:
			return 'دسترسی شما به این تراکنش رد شد, Authority این تراکنش برای MerchantID شما ثبت نشده است';
		case -18:
			return 'پرداخت تراکنش با موفقیت انجام شده است, اما در بروزرسانی کیف پول پذیرنده مشکلی پیش آمده است';
		case -19:
			return 'وضعیت تراکنش نامشخص است';
		case 100:
			return 'عملیات با موفقیت انجام شد';
		case 101:
			return 'عملیات این تراکنش با موفقیت انجام شد ولی قبلا عملیات اعتبار سنجی بر روی این تراکنش انجام شده است';
	}

	return 'خطای نامشخص';
}

function BANIAPP_GetCallBackURL()
{
	$pageURL 			= (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";

	$ServerName 		= htmlspecialchars($_SERVER["SERVER_NAME"], ENT_QUOTES, "utf-8");
	$ServerPort 		= htmlspecialchars($_SERVER["SERVER_PORT"], ENT_QUOTES, "utf-8");
	$ServerRequestUri 	= htmlspecialchars($_SERVER["REQUEST_URI"], ENT_QUOTES, "utf-8");

	if ($_SERVER["SERVER_PORT"] != "80")
	{
		$pageURL .= $ServerName .":". $ServerPort . $_SERVER["REQUEST_URI"];
	} else {
		$pageURL .= $ServerName . $ServerRequestUri;
	}

	return $pageURL;
}
?>